/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.WhistleUseData;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class WhistleUsePacket
implements IPacket<WhistleUseData> {
    @Override
    public void encode(WhistleUseData data, FriendlyByteBuf buf) {
        buf.writeInt(data.mode_id);
    }

    @Override
    public WhistleUseData decode(FriendlyByteBuf buf) {
        return new WhistleUseData(buf.readInt());
    }

    @Override
    public void handle(WhistleUseData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            WhistleItem whistle;
            LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
            if (!side.isServer()) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack whistle_stack = InventoryUtil.findStackWithItemFromHands((Player)player, whistle = DoggyItems.WHISTLE.get());
            if (whistle_stack == null) {
                return;
            }
            if (player.m_36335_().m_41519_((Item)whistle)) {
                return;
            }
            WhistleItem.WhistleMode[] whistle_modes = WhistleItem.WhistleMode.VALUES;
            if (data.mode_id >= whistle_modes.length) {
                return;
            }
            if (data.mode_id < 0) {
                return;
            }
            WhistleItem.WhistleMode useMode = whistle_modes[data.mode_id];
            List dogsList = player.m_9236_().m_6443_(Dog.class, player.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)player));
            whistle.useMode(useMode, dogsList, player.m_9236_(), (Player)player, InteractionHand.MAIN_HAND, true);
        });
        ctx.get().setPacketHandled(true);
    }
}

